/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.perfhook;

import ibm.nways.analysis.dpCommon.DpNullResourceManagerException;
import ibm.nways.analysis.dpCommon.DpResourceInstance;
import ibm.nways.analysis.dpCommon.DpResourceManager;
import ibm.nways.analysis.dpCommon.DpResourceState;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.RemoteModelImpl;
import ibm.nways.jdm.RemoteModelWithStatus;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.modelgen.HandcodedModel;
import ibm.nways.jdm.modelgen.LocalModel;
import ibm.nways.jdm.modelgen.NeedsParentsInstrType;
import ibm.nways.jdm.modelgen.SnmpInstrContext;
import ibm.nways.perfhook.PerfModel;
import ibm.nways.perfhook.PerfService;
import java.rmi.RemoteException;

public class PerfModelImpl
extends RemoteModelImpl
implements PerfModel,
RemoteModelWithStatus,
DpResourceManager,
HandcodedModel,
NeedsParentsInstrType {
    protected SnmpInstrContext context;
    protected String instrType;
    protected RemoteStatus status;
    protected LocalModel localmod;

    public void initLocalModel(LocalModel localModel) {
        this.localmod = localModel;
        this.context = (SnmpInstrContext)this.localmod.getContext();
        try {
            this.status = this.localmod.getRemoteStatusObj(null);
            return;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return;
        }
    }

    public void useParentsInstrType(String string) {
        PerfService perfService;
        this.instrType = string.startsWith("ibm.nways.") ? string.substring(10) : string;
        if (this.instrType.endsWith("SnmpInstr")) {
            this.instrType = this.instrType.substring(0, this.instrType.length() - 9);
        }
        if ((perfService = (PerfService)JdmServerImpl.getSingleton().getService((Object)"PollingService")) != null) {
            try {
                perfService.addResourceInstance(this);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        System.err.println("Cannot find PollingService");
    }

    public String getHostname() throws RemoteException {
        return this.context.getSession().getIpAddress();
    }

    public String getCommName() throws RemoteException {
        return this.context.getSession().getCommName();
    }

    public String getResourceType() throws RemoteException {
        return this.instrType;
    }

    public void dispose() {
        PerfService perfService = (PerfService)JdmServerImpl.getSingleton().getService((Object)"PollingService");
        if (perfService != null) {
            try {
                perfService.clearResourceInstance(this);
            }
            catch (Exception exception) {}
        }
        this.context = null;
        this.status = null;
        this.setTopLevelRef(null);
        this.localmod.dispose();
        this.localmod = null;
    }

    public void reallyDispose() {
        PerfService perfService = (PerfService)JdmServerImpl.getSingleton().getService((Object)"PollingService");
        if (perfService != null) {
            try {
                perfService.removeResourceInstance(this);
            }
            catch (Exception exception) {}
        }
        this.dispose();
    }

    public RemoteStatus getStatus() throws RemoteException {
        return this.status;
    }

    public String dpGetHostname() {
        return this.context.getSession().getIpAddress();
    }

    public String dpGetCommunityName() {
        return this.context.getSession().getCommName();
    }

    public String dpGetDeviceType() {
        return null;
    }

    public String dpGetResourceType() {
        return this.instrType;
    }

    public DpResourceInstance dpGetResourceInstance() {
        return null;
    }

    public void dpSetState(DpResourceState dpResourceState) throws DpNullResourceManagerException {
        if (this.status == null) {
            throw new DpNullResourceManagerException();
        }
        try {
            this.status.setStatusType(dpResourceState.getStatusType(), dpResourceState.getExplanation(), true);
            return;
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return;
        }
    }
}

